	list p=16f84 		;SK3-1: (1) PUSHER - A clean sweep.
 				;(2) PUSHER - Random demolition.
 				;(3) GRABBER - Search and eliminate.
 				;(4) GRABBER -Deal the pack.

	status		equ 03h
	porta		equ 05h
	portb		equ 06h
	trisa		equ 05h
	trisb		equ 06h
	w		equ 00h
	f		equ 01h
	z		equ 02h
	delay0		equ 0Ch
	delay1 		equ 0Dh
	delay2 		equ 0Eh
	object		equ 0Fh
	scans		equ 10h
	rasters		equ 11h
	steps		equ 12h
	stations	equ 13h
	address 	equ 14h
	tries	 	equ 15h
	distance	equ 16h
	angle	 	equ 17h
	random 		equ 18h
	bitn	 	equ 19h
	bitm	 	equ 1Ah

 	goto start
 	org 0004h
 	goto start

start:	bsf status, 5	;Page 1.
 	clrf trisa	;RA0 to RA4 as outputs.
 	movlw 0CFh
 	movwf trisb	;RB4 and RB5 as outputs.
 	clrwdt
 	bcf status, 5	;Page 0.

	clrf porta	;Clear Port A.
 	bsf porta, 4	;Group A selected.
 	clrf portb	;Clear Port B.
 	movlw 0F0h
 	call pause2	;Call Pause2.
 	btfsc portb,1	;Select switch S2.
 	goto s2on
 	btfsc portb,0	;Select switch S1.
 	goto behave2
 	goto behave1
s2on:	btfsc portb,0
	goto behave4
	goto behave3

	;------------------------------------------------------------------;

behave1: 
 	movlw 0A0h	;40 cm.
 	movwf distance
 	movlw 06h	;10 degrees.
 	movwf angle
newsweep:
 	movlw 010h	;16 rasters.
 	movwf rasters
 	call pushdown

sweep:
 	movlw 05h	;Reverse.
	movwf porta
 	movf distance, w
 	call pause2
 	movlw 09h	;Spin left.
 	movwf porta
 	movf angle, w
 	call pause2
 	clrf porta	;Stop.
 	call pushup	;Raise pusher.
 	movlw 0Ah	;Forward.
 	movwf porta
 	movf distance, w
 	call pause2
 	movlw 06h	;Spin right.
 	movwf porta
 	movf angle, w
 	call pause2
 	clrf porta	;Stop.
 	decf rasters, f ;Count down.
 	btfss status, 2	;rasters =0?
 	goto sweep
 	movlw 0FFh	;Long delay.
 	call pause2
 	btfss portb, 7	;If left sensor on white.
 	goto setangle 	;To change angle.
 	goto newsweep	;Repeat, angle unchanged.

setangle:
 	movlw 03h	;Load change of angle.
 	btfss portb, 6 	;If right sensor on white.
 	goto bigger
 	subwf angle, f	;Reduce angle.
 	btfss status, 2	;Angle = 0?
 	goto newsweep
 	addwf angle, f	;Restore angle.
 	goto newsweep
bigger:
 	addwf angle, f	;Increase angle.
 	btfss status, 0	;Angle > 0FFh?
 	goto newsweep
 	subwf angle, f	;Restore angle.
 	goto newsweep	;END of BEHAVE1.

	;------------------------------------------------------------------;

behave2:
 	call pushup
 	movlw 0DBh	;Seed.
 	movwf random
monte:
 	clrf bitn	;Clear bit registers.
 	clrf bitm
 	btfss random, 5	;Is n = 1?
 	goto findm	;No: now find m.
 	bsf bitn, 0	;Yes: make bitn = 1.
findm:
 	btfss random, 6	;Is m = 1?
 	goto xorem	;No: go to 'logic gate'.
 	bsf bitm, 0	;Yes: make bitm = 1.
xorem:
	movf bitn, w
 	xorwf bitm, w	;xor bitn with bitm.
 	addlw 0FFh	;Set carry if w = 1.
 	rlf random, f 
 	movf random, w	;Random to motors.
 	movwf porta	;This may CHANGE RA4!
 	movlw 020h;1 s.
 	call pause2
 	clrf porta
 	call detect	;Object ahead?
 	movlw 0FDh
 	addwf object, w
 	btfsc status, 2
 	goto charge
 	goto monte	;For next random action.
charge:
 	call pushdown
 	movlw 05h	;Reverse motors.
 	movwf porta
 	movlw 040h	;2 s.
 	call pause2
 	clrf porta
 	call pushup
 	goto monte

	;------------------------------------------------------------------;

behave3:
 	movlw 05h
 	movwf tries	;tries = 5.
 	call ready
tryagain:
 	call jopen
 	call raster
 	movlw 0FDh	;Object detected?
 	addwf object, w
 	btfsc status, 2
 	goto found
 
waiting:
 	call jopen
 	call detect
 	movlw 0FDh
 	addwf object, w
 	btfsc status, z
 	goto found
 	goto waiting	;No, look again.

found:
 	call grabbit
 	sublw 01h	;0 or 1 in w?
 	btfss status, z	;Test z.
 	goto nextgo
 
 	movlw 09h	;Run away. Spin left.
 	movwf porta
 	movlw 010h
 	call pause2
 	movlw 0Ah	;Forward.
 	movwf porta
 	movlw 0C0h
 	call pause2
 	movlw 06h	;Spin right.
 	movwf porta
 	movlw 010h
 	call pause2
 	movlw 0Ah	;Forward.
 	movwf porta
 	movlw 0C0h
 	call pause2
 	clrf porta
 	call jopen
 	movlw 0Ah	;Forward to clear object.
 	movwf porta
 	movlw 020h
 	call pause2
 	movlw 06h	;Spin right.
 	movwf porta
 	movlw 030h
 	call pause2
 	clrf porta
 	bsf porta, 4	;Group A.
down:
 	movlw 020h	;Lower jaws.
 	movwf portb
 	movlw 020h
 	call pause2
 	clrf portb
 	nop
 	btfss portb, 2	;If resting.
 	goto down
doneit: goto doneit	;END of BEHAVE3.

nextgo:
	movlw 05h	;5 tries allowed.
 	subwf tries, w
 	btfsc status, z
 	goto waiting
 	incf tries, f
 	goto tryagain

	;--------------------------------------------------------------------;

behave4:
 	clrf stations	;Stations = 0.
 	clrf address	;Address = 0.
 	incf address, f	;Address = 1.
 	call ready
 	goto circulate	;END of BEHAVE4.
 
	;--------------------------------------------------------------------;

pushdown:
 	bsf porta, 4	;Group A.
downit:
 	movlw 020h	;Lower pusher.
 	movwf portb
 	movlw 08h
 	call pause2
 	clrf portb	;Stop motor.
 	nop
 	btfss portb, 2 	;If pusher is down.
 	goto downit
 	movlw 010h	;Final raise.
 	movwf portb
 	movlw 040h
 	call pause2
 	clrf portb	;Stop.
 	return

pushup:
 	call pushdown
 	movlw 010h	;Raise further.
 	movwf portb
 	movlw 060h	;3 sec.
 	call pause2
 	clrf portb	;Stop.
 	return

ready: 
 	bsf porta, 4	;Group A.
 	movlw 03h
 	call pause2
 	btfss portb, 2	;If resting.
 	goto lower	;To lower.
 	movlw 010h	;Raise winch.
 	movwf portb
 	movlw 020h	;1 s.
 	call pause2
 	clrf portb
 	nop
 	goto ready	;To check again.
lower:
 	movlw 020h	;Lower winch.
 	movwf portb
 	movlw 020h	;1 s.
 	call pause2
 	clrf portb
 	nop
 	btfss portb, 2	;If resting.
 	goto lower	;To lower more.
 	movlw 010h
 	movwf portb
 	movlw 0FFh	;Final lift 8 s.
 	call pause2
 	clrf portb
 	return

jopen:
 	bcf porta, 4	;Group B.
 	btfsc portb, 0	;If jaws not wide open.
 	return
 	movlw 020h	;Open jaws.
 	movwf portb
 	movlw 02h
 	call pause2
 	clrf portb
 	goto jopen

detect:
 	bsf porta, 4	;Group A.
waitoff1:
 	btfsc portb, 3	;If red LED is off.
 	goto waitoff1 
waiton1:
 	btfss portb, 3	;If red LED is on.
 	goto waiton1
 	bcf porta, 4	;Group B. LED is on. Red-on is high
 			;and LDR should be low.
 	movlw 0Ah	;0.375 s. to settle.
 	call pause2
 	clrf object	;Clear object status code.
 	btfss portb, 3	;1st sample LDR; if is hi, skip.
 	bsf object, 0	;Because object (or swamped).
 	bsf porta, 4	;Group A.
waitoff2:
 	btfsc portb, 3	;If red LED is off again.
 	goto waitoff2
 	bcf porta, 4	;Group B. LED is off. Red-on is low
 			;and LDR should be high.
 	movlw 0Ah	;0.375 s. to settle.
 	call pause2
 	btfsc portb, 3	;2nd sample LDR; if it is lo, skip.
 	bsf object, 1	;Because object (or no object).
 			;object=03h if object present.
 	return

grabbit:
 	movlw 05h	;Reverse.
 	movwf porta
 	movlw 010h	;Move a little closer.
 	call pause2
 	clrf porta	;Stop.
 	bcf porta, 4	;Group B.
 	movlw 010h
 	movwf portb
 	movlw 010h	;0.5 s.
 	call pause2
feeling:
 	btfsc portb, 1	;If not yet closed, no object.
 	goto nothing	;If closed, but no object.
 	btfsc portb, 2	;If not yet closed on object.
 	goto grabbing	;If closed on object.
 	goto feeling 	;To continue closing.
nothing:
 	clrf portb	;Stop jaws motor.
 	retlw 00h	;Nothing grabbed.
grabbing:
 	movlw 010h	;Tighten grip on object.
 	movwf portb
 	movlw 020h	;1 s.
 	call pause2
 	clrf portb	;Stop jaws motor.
 	bsf porta, 4	;Group A.
 	movlw 010h	;Winch motor to raise jaws.
 	movwf portb
lifting:
 	movlw 020h	;1 s, taking up slack, if any.
 	call pause2
 	btfsc portb, 2	;If clear of ground.
 	goto lifting
 	movlw 0C0h	;6 s., lift higher.
 	call pause2
 	clrf portb	;Stop winch motor.
 	retlw 01h	;With object in jaws.

circulate: 
 	movlw 0Ah	;Both motors forward.
 	movwf porta
 	movlw 02h
 	call pause2
 	clrf porta	;Stop.
 	btfss portb, 6	;Skip if veering right or on line.
 	goto station 	;If veering left or at station.
 	btfss portb, 7	;Skip if on line.
 	goto spinl	;Is veering right, so correct it.
 	goto circulate	;On line or free.
station:
 	btfss portb, 7	;Skip if veering left.
 	goto deal	;Is at station.
 	goto spinr	;Is veering left, so correct it.
spinl:
 	movlw 09h	;Spin left.
 	movwf porta
 	movlw 03h
 	call pause2
 	clrf porta
 	goto circulate
spinr:
 	movlw 06h	;Spin right.
 	movwf porta
 	movlw 03h
 	call pause2
 	clrf porta
 	goto circulate
deal: 
 	movf stations, f ;Test stations.
 	btfsc status, z	;If station not 0.
 	call pickup	;To collect an object.
 	movf stations, w ;Test stations.
 	subwf address, w ;Compare with address.
 	btfsc status, z	;station = address ?
 	call jopen	;To drop the object.
 	movlw 0Ah	;Forward, to clear station.
 	movwf porta
 	movlw 08h
 	call pause2
 	clrf porta	;Stop.
 	incf stations, f ;Counting up.
 	btfss stations, 2 ;Station = 4?
 	goto circulate	;No - carry on. 
	clrf stations ;Yes - reset station.
 	incf address, f ;Counting up.
 	btfss address, 2 ;Address = 4?
 	goto circulate	;No - carry on.
 	clrf address	;Yes - reset address
 	goto circulate	;and carry on.
 
pickup:
 	call jopen
repeat:
 	call detect
 	movlw 0FDh
 	addwf object, w
 	btfss status, z
 	goto repeat	;Until object detected.
 	call takeit	;To grasp object.
 	return
 
raster:
 	movlw 014h	;Allow 20 rasters.
 	movwf rasters
routine:
 	movlw 08h	;Allow 8 steps.
 	movwf steps
stepping:
	call detect
 	movlw 0FDh
 	addwf object, w
 	btfsc status, z
 	return
 	movlw 05h	;Reverse.
 	movwf porta
 	movlw 010h	;25 mm.
 	call pause2
 	clrf porta
 	decfsz steps, f	;Counting down steps.
 	goto stepping
 	movlw 09h	;Spin left.
 	movwf porta
 	movlw 04h	;5 degrees.
 	call pause2
 	clrf porta
 	movlw 0Ah	;Forward.
 	movwf porta
 	movlw 080h	;300 mm.
 	call pause2
 	clrf porta
 	movlw 06h	;Spin right.
 	movwf porta
 	movlw 04h	;5 degrees.
 	call pause2
 	clrf porta
 	decfsz rasters, f ;Counting down rasters.
 	goto routine
 	return

takeit:
 	bcf porta, 4	;Group B
 	movlw 010h	;Close jaws.
 	movwf portb
 	movlw 010h	;0.5 s.
 	call pause2
 	clrf portb	;Stop closing
 	nop
 	btfsc portb, 2	;If no pressure.
 	goto grip 	;If pressure - object held.
 	goto takeit
grip:
 	btfsc portb, 1	;If not closed.
 	return		;If closed - no object or thin object.
 	movlw 010h	;Not closed - tighten jaws.
 	movwf portb
 	movlw 010h
 	call pause2
 	clrf portb	;Stop.
 	nop
 	return
 
pause2:
 	movwf delay2	;Already has value in w.
dloop2:
 	call pause1
 	decfsz delay2,f
 	goto dloop2
 	return
pause1:
 	movlw 1h
 	movwf delay1
dloop1:
 	call pause0
 	decfsz delay1,f
 	goto dloop1
 	return
pause0:
 	movlw 80h
 	movwf delay0
dloop0:
 	decfsz delay0,f
 	goto dloop0
 	return

	end
